// ANIMATED TYPING TEXT

jQuery(document).ready(function($){
	//set animation timing
	var animationDelay = 1500,
		//loading bar effect
		barAnimationDelay = 3800,
		barWaiting = barAnimationDelay - 3000, //3000 is the duration of the transition on the loading bar - set in the scss/css file
		//letters effect
		lettersDelay = 50,
		//type effect
		typeLettersDelay = 100,
		selectionDuration = 300,
		typeAnimationDelay = selectionDuration + 400,
		//clip effect 
		revealDuration = 400,
		revealAnimationDelay = 500;
	
	initHeadline();
	

	function initHeadline() {
		//insert <i> element for each letter of a changing word
		singleLetters($('.cd-headline.letters').find('b'));
		//initialise headline animation
		animateHeadline($('.cd-headline'));
	}

	function singleLetters($words) {
		$words.each(function(){
			var word = $(this),
				letters = word.text().split(''),
				selected = word.hasClass('is-visible');
			for (i in letters) {
				if(word.parents('.rotate-2').length > 0) letters[i] = '<em>' + letters[i] + '</em>';
				letters[i] = (selected) ? '<i class="in">' + letters[i] + '</i>': '<i>' + letters[i] + '</i>';
			}
		    var newLetters = letters.join('');
		    word.html(newLetters).css('opacity', 1);
		});
	}

	function animateHeadline($headlines) {
		var duration = animationDelay;
		$headlines.each(function(){
			var headline = $(this);
			
			if(headline.hasClass('loading-bar')) {
				duration = barAnimationDelay;
				setTimeout(function(){ headline.find('.cd-words-wrapper').addClass('is-loading') }, barWaiting);
			} else if (headline.hasClass('clip')){
				var spanWrapper = headline.find('.cd-words-wrapper'),
					newWidth = spanWrapper.width() + 10
				spanWrapper.css('width', newWidth);
			} else if (!headline.hasClass('type') ) {
				//assign to .cd-words-wrapper the width of its longest word
				var words = headline.find('.cd-words-wrapper b'),
					width = 0;
				words.each(function(){
					var wordWidth = $(this).width();
				    if (wordWidth > width) width = wordWidth;
				});
				headline.find('.cd-words-wrapper').css('width', width);
			};

			//trigger animation
			setTimeout(function(){ hideWord( headline.find('.is-visible').eq(0) ) }, duration);
		});
	}

	function hideWord($word) {
		var nextWord = takeNext($word);
		
		if($word.parents('.cd-headline').hasClass('type')) {
			var parentSpan = $word.parent('.cd-words-wrapper');
			parentSpan.addClass('selected').removeClass('waiting');	
			setTimeout(function(){ 
				parentSpan.removeClass('selected'); 
				$word.removeClass('is-visible').addClass('is-hidden').children('i').removeClass('in').addClass('out');
			}, selectionDuration);
			setTimeout(function(){ showWord(nextWord, typeLettersDelay) }, typeAnimationDelay);
		
		} else if($word.parents('.cd-headline').hasClass('letters')) {
			var bool = ($word.children('i').length >= nextWord.children('i').length) ? true : false;
			hideLetter($word.find('i').eq(0), $word, bool, lettersDelay);
			showLetter(nextWord.find('i').eq(0), nextWord, bool, lettersDelay);

		}  else if($word.parents('.cd-headline').hasClass('clip')) {
			$word.parents('.cd-words-wrapper').animate({ width : '2px' }, revealDuration, function(){
				switchWord($word, nextWord);
				showWord(nextWord);
			});

		} else if ($word.parents('.cd-headline').hasClass('loading-bar')){
			$word.parents('.cd-words-wrapper').removeClass('is-loading');
			switchWord($word, nextWord);
			setTimeout(function(){ hideWord(nextWord) }, barAnimationDelay);
			setTimeout(function(){ $word.parents('.cd-words-wrapper').addClass('is-loading') }, barWaiting);

		} else {
			switchWord($word, nextWord);
			setTimeout(function(){ hideWord(nextWord) }, animationDelay);
		}
	}

	function showWord($word, $duration) {
		if($word.parents('.cd-headline').hasClass('type')) {
			showLetter($word.find('i').eq(0), $word, false, $duration);
			$word.addClass('is-visible').removeClass('is-hidden');

		}  else if($word.parents('.cd-headline').hasClass('clip')) {
			$word.parents('.cd-words-wrapper').animate({ 'width' : $word.width() + 10 }, revealDuration, function(){ 
				setTimeout(function(){ hideWord($word) }, revealAnimationDelay); 
			});
		}
	}

	function hideLetter($letter, $word, $bool, $duration) {
		$letter.removeClass('in').addClass('out');
		
		if(!$letter.is(':last-child')) {
		 	setTimeout(function(){ hideLetter($letter.next(), $word, $bool, $duration); }, $duration);  
		} else if($bool) { 
		 	setTimeout(function(){ hideWord(takeNext($word)) }, animationDelay);
		}

		if($letter.is(':last-child') && $('html').hasClass('no-csstransitions')) {
			var nextWord = takeNext($word);
			switchWord($word, nextWord);
		} 
	}

	function showLetter($letter, $word, $bool, $duration) {
		$letter.addClass('in').removeClass('out');
		
		if(!$letter.is(':last-child')) { 
			setTimeout(function(){ showLetter($letter.next(), $word, $bool, $duration); }, $duration); 
		} else { 
			if($word.parents('.cd-headline').hasClass('type')) { setTimeout(function(){ $word.parents('.cd-words-wrapper').addClass('waiting'); }, 200);}
			if(!$bool) { setTimeout(function(){ hideWord($word) }, animationDelay) }
		}
	}

	function takeNext($word) {
		return (!$word.is(':last-child')) ? $word.next() : $word.parent().children().eq(0);
	}

	function takePrev($word) {
		return (!$word.is(':first-child')) ? $word.prev() : $word.parent().children().last();
	}

	function switchWord($oldWord, $newWord) {
		$oldWord.removeClass('is-visible').addClass('is-hidden');
		$newWord.removeClass('is-hidden').addClass('is-visible');
	}
});




// SWIPEABLE GALLERY

$('.gallery').flickity({
	initialIndex: 0,
	wrapAround: true,
	draggable: true,
	autoPlay: false,
	cellAlign: 'center',
	imagesLoaded: true,
	selectedAttraction: 0.10,
	friction: 0.80,
	adaptiveHeight: false,
	pageDots: true,
	prevNextButtons: true
});




// HIGHLIGHT NAVIGATION

$(document).ready(function(){
     $("#about").mouseover(function(){
         $("#aboutnav").css("color", "var(--color-primary)");
     });
     $("#about").mouseout(function(){
         $("#aboutnav").css("color", "var(--font-color)");
     });
    
     $("#skills").mouseover(function(){
         $("#skillsnav").css("color", "var(--color-primary)");
     });
     $("#skills").mouseout(function(){
         $("#skillsnav").css("color", "var(--font-color)");
     });
    
     $("#casestudies").mouseover(function(){
         $("#casestudiesnav").css("color", "var(--color-primary)");
     });
     $("#casestudies").mouseout(function(){
         $("#casestudiesnav").css("color", "var(--font-color)");
     });
    
     $("#work").mouseover(function(){
         $("#worknav").css("color", "var(--color-primary)");
     });
     $("#work").mouseout(function(){
         $("#worknav").css("color", "var(--font-color)");
     });
        
     $("#contact").mouseover(function(){
         $("#contactnav").css("color", "var(--color-primary)");
     });
     $("#contact").mouseout(function(){
         $("#contactnav").css("color", "var(--font-color)");
     });
});




// MOBILE MENU

$(".mobilemenu").click(function(){
	$(this).toggleClass("active");
	$(".menuright").fadeToggle("slow");
	$(".close").fadeToggle("slow");
});
$(".close").click(function(){
	$(".mobilemenu").toggleClass("active");
    $(this).fadeToggle("slow");
	$(".menuright").fadeToggle("slow");
});




// HIDE VIDEO CONTROLS IN FIREFOX

var vids = $("video"); 
$.each(vids, function(){
       this.controls = false; 
}); 




// REVEAL ON SCROLL

ScrollReveal().reveal('.reveal', { reset: false });
ScrollReveal().reveal('.tile', { interval: 20, reset: false });
ScrollReveal().reveal('#body .reveal', { container: '#body' });
ScrollReveal().reveal('#body .tile', { container: '#body' });




// SORTABLE GRID

var containerEl1 = document.querySelector('[data-ref="container-1"]');
var containerEl2 = document.querySelector('[data-ref="container-2"]');

var config = {
	controls: {
		scope: 'local'
	}
};

var mixer1 = mixitup(containerEl1, config);
var mixer1 = mixitup(containerEl2, config);




