$(document).ready(function () {
	var hash = (window.location.hash);
	if (hash == "#success"){
		$('#thanks').fancybox({overlayShow: true}).click(); /*show the thanks bit if hastage of #success present*/
	}

	$("#FirstName").click(function(){
		removeErr("FirstName");
	});
	$("#Surname").click(function(){
		removeErr("Surname");
	});
	$("#Email").click(function(){
		removeErr("Email");
	});
	$("#Postcode").click(function(){
		removeErr("Postcode");
	});
	$("#TermsAndConditionsAccepted").click(function(){
		removeErrLabel("TermsAndConditionsAccepted");
	});
	
	$("#FirstName").bind("change focusout", function(){
		if (!isComplete("FirstName")){
			setErr("FirstName");
		}else{
			removeErr("FirstName");
		}
	});
	$("#Surname").bind("change focusout", function(){
		if (!isComplete("Surname")){
			setErr("Surname");
		}else{
			removeErr("Surname");
		}
	});
	$("#Email").bind("change focusout", function(){
		if (!isComplete("Email")){
			setErr("Email");
		}else{
			if (!isValidEmail("Email")) {
				setErr("Email");
			}else{
				removeErr("Email");
			}
		}
	});
	$("#Postcode").bind("change focusout", function(){
		if (!isPostcode("Postcode")) {
			setErr("Postcode");
		}else{
			formatPostcode("Postcode");
			removeErr("Postcode");
		}
	});
	
	
	
});

function validateForm(){
	var err = "";
	
	removeErr("FirstName");
	removeErr("Surname");
	removeErr("Email");
	removeErrLabel("TermsAndConditionsAccepted");
	removeErr("Postcode");
	removeErr("txtInput");
	
//	if (!isQuestionAnswered("CNForm_CompetitionAnswer")){
//		err += "Please answer the question\n";
//	}
	
    if (!isComplete("FirstName")){
        err += "Please enter your first name\n";
		setErr("FirstName");
    }
    if (!isComplete("Surname")) {
        err += "Please enter your surname\n";
		setErr("Surname");
    }
    if (!isComplete("Email")) {
        err += "Please enter your email\n";
		setErr("Email");
    }else{
		if (!isValidEmail("Email")) {
			err += "The email address you've entered appears to be invalid\n";
			setErr("Email");
		}
	}
	if (!isPostcode("Postcode")) {
		err += "The postcode you entered appears to be invalid\n";
		setErr("Postcode");
    }else{
		formatPostcode("Postcode");
	}
	
    if (!isChecked("TermsAndConditionsAccepted")) {
        err += "You must accept the terms and conditions to enter the competition\n";
		setErrLabel("TermsAndConditionsAccepted");
    }
	
//	if(!isComplete("txtInput")){
//		err += "Please enter the captcha code\n";
//		setErr("txtInput");
//	}else{	
//		if(ValidCaptcha(document.compform.txtInput.value) == false){
//			err += "Please enter the captcha code\n";
//			//setCaptchaErrLabel("captchalabel", "Please enter valid captcha code.");
//		}
//	}
    if (err.length > 0) {
        //alert("You must fix the following errors in your entry:\n\n" + err);
        return false;
    }
	
	$("#aspnetForm").attr("action", "http://formdata.condenet.co.uk/captures/");
    $("#__VIEWSTATE").remove();
    $("form").submit();
	return true;
}

function setErr(elem){
	$("#" + elem).addClass("texterror");
}

function setErrLabel(elem){
	$("label[for=" + elem + "]").addClass("compotionserror");
}

//function setCaptchaErrLabel(elem, errorMsg){
//	$("#" + elem).addClass("compotionserror");
//	$("#captchalabel").html(errorMsg);
//}

function removeErr(elem){
	$("#" + elem).removeClass("texterror");
}

function removeErrLabel(elem){
	$("label[for=" + elem + "]").removeClass("compotionserror");
}

function isQuestionAnswered(elem){
	if ($("input[name=" + elem + "]:checked").val() == undefined){
		return false;
	}else{
		return true;
	}
}

function isValidEmail(elem){
	var val = $("#" + elem).val();
	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
	if(reg.test(val) == false) {
		return false;
	}else{
		return true;
	}
}

function isComplete(elem){
	var val = $("#" + elem).val();
	if (val.length == 0){
		return false;
	}else{
		return true;
	}
}

function isChecked(elem){
	return $("#" + elem).is(':checked');
}

function isPostcode(elem){
	return checkPostCode ($("#" + elem).val());
}

function formatPostcode(elem){
	$("#" + elem).val(checkPostCode ($("#" + elem).val()));
}

function checkPostCode (toCheck) {
	// Permitted letters depend upon their position in the postcode.
	var alpha1 = "[abcdefghijklmnoprstuwyz]"; // Character 1
	var alpha2 = "[abcdefghklmnopqrstuvwxy]"; // Character 2
	var alpha3 = "[abcdefghjkpmnrstuvwxy]"; // Character 3
	var alpha4 = "[abehmnprvwxy]";// Character 4
	var alpha5 = "[abdefghjlnpqrstuwxyz]";// Character 5
	// Array holds the regular expressions for the valid postcodes
	var pcexp = new Array ();
	// Expression for postcodes: AN NAA, ANN NAA, AAN NAA, and AANN NAA
	pcexp.push (new RegExp ("^(" + alpha1 + "{1}" + alpha2 + "?[0-9]{1,2})(\\s*)([0-9]{1}" + alpha5 + "{2})$","i"));
	// Expression for postcodes: ANA NAA
	pcexp.push (new RegExp ("^(" + alpha1 + "{1}[0-9]{1}" + alpha3 + "{1})(\\s*)([0-9]{1}" + alpha5 + "{2})$","i"));
	// Expression for postcodes: AANANAA
	pcexp.push (new RegExp ("^(" + alpha1 + "{1}" + alpha2 + "{1}" + "?[0-9]{1}" + alpha4 +"{1})(\\s*)([0-9]{1}" + alpha5 + "{2})$","i"));
	// Exception for the special postcode GIR 0AA
	pcexp.push (/^(GIR)(\s*)(0AA)$/i);
	// Standard BFPO numbers
	pcexp.push (/^(bfpo)(\s*)([0-9]{1,4})$/i);
	// c/o BFPO numbers
	pcexp.push (/^(bfpo)(\s*)(c\/o\s*[0-9]{1,3})$/i);
	// Overseas Territories
	pcexp.push (/^([A-Z]{4})(\s*)(1ZZ)$/i);
	// Anguilla
	pcexp.push (/^(ai-2640)$/i);
	// Load up the string to check
	var postCode = toCheck;
	// Assume we're not going to find a valid postcode
	var valid = false;
	// Check the string against the types of post codes
	for ( var i=0; i<pcexp.length; i++) {
		if (pcexp[i].test(postCode)) {
		// The post code is valid - split the post code into component parts
		pcexp[i].exec(postCode);
		// Copy it back into the original string, converting it to uppercase and inserting a space 
		// between the inward and outward codes
		postCode = RegExp.$1.toUpperCase() + " " + RegExp.$3.toUpperCase();
		// If it is a BFPO c/o type postcode, tidy up the "c/o" part
		postCode = postCode.replace (/C\/O\s*/,"c/o ");
		// If it is the Anguilla overseas territory postcode, we need to treat it specially
		if (toCheck.toUpperCase() == 'AI-2640') {postCode = 'AI-2640'};
		// Load new postcode back into the form element
		valid = true;
		// Remember that we have found that the code is valid and break from loop
		break;
		}
	}
	// Return with either the reformatted valid postcode or the original invalid postcode
	if (valid) {return postCode;} else return false;
}

// Validate the Entered input aganist the generated security code function
function ValidCaptcha(){
	var str1 = removeSpaces(document.getElementById('txtCaptcha').value);
	var str2 = removeSpaces(document.getElementById('txtInput').value);
	if (str1 == str2){
		return true;
	}else{
		return false;
	}
}
// Remove the spaces from the entered and generated code
function removeSpaces(string){
	return string.split(' ').join('');
}