import Swiper from 'swiper';

export default {
    init() {
        // JavaScript to be fired on all pages

        if ($('.gallery .swiper-container').length) {
            var Carousel = new Swiper('.gallery .swiper-container', {
                init: false,
                // autoHeight: true,
                // spaceBetween: 0,
                pagination: {
                    el: '.swiper-pagination',
                    type: 'bullets',
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
            });


            setTimeout(function () {
                Carousel.init()
            }, 1000)
        }

        function new_map($el) {
            // var
            var $markers = $el.find('.marker');
            // vars
            var args = {
                zoom: 16,
                center: new window.google.maps.LatLng(0, 0),
                mapTypeId: window.google.maps.MapTypeId.ROADMAP,
            };
            // create map
            var map = new window.google.maps.Map($el[0], args);
            // add a markers reference
            map.markers = [];
            // add markers
            $markers.each(function () {
                add_marker($(this), map);
            });
            // center map
            center_map(map);
            // return
            return map;
        }

        function add_marker($marker, map) {
            // var
            var latlng = new window.google.maps.LatLng($marker.attr('data-lat'), $marker.attr('data-lng'));
            // create marker
            var marker = new window.google.maps.Marker({
                position: latlng,
                map: map,
            });
            // add to array
            map.markers.push(marker);
            // if marker contains HTML, add it to an infoWindow
            if ($marker.html()) {
                // create info window
                var infowindow = new window.google.maps.InfoWindow({
                    content: $marker.html(),
                });
                // show info window when marker is clicked
                window.google.maps.event.addListener(marker, 'click', function () {
                    infowindow.open(map, marker);
                });
            }
        }

        function center_map(map) {
            // vars
            var bounds = new window.google.maps.LatLngBounds();
            // loop through all markers and create bounds
            $.each(map.markers, function (i, marker) {
                var latlng = new window.google.maps.LatLng(marker.position.lat(), marker.position.lng());
                bounds.extend(latlng);
            });
            // only 1 marker?
            if (map.markers.length == 1) {
                // set center of map
                map.setCenter(bounds.getCenter());
                map.setZoom(16);
            }
            else {
                // fit to bounds
                map.fitBounds(bounds);
            }
        }

        $(document).ready(function () {
            $('.gmap').each(function () {
                // create map
                new_map($(this));
            });
        });

        // Scrolls to bottom of parent element
        $('.scroller__single-pillar').click(function () {
            $('html, body').animate({
                scrollTop: $(this).parent().offset().top + $(this).parent().height() - $('.sticky-top').height(),
            }, 2000);
            $(this).fadeOut();
        });

        $('.scroller__boxes').click(function () {
            var elTopOffset = $(this).parent().offset().top;
            var elHeight = $(this).parent().height();
            var windowHeight = $(window).height();

            $('html, body').animate({
                scrollTop: elTopOffset - windowHeight + elHeight,
            }, 2000);

            $(this).fadeOut();
        });

        $('.oembed__cover .play-btn').click(function () {
            $(this).parent().fadeOut(500, function () {
                $(this).parent().parent().find('iframe')[0].src += "&autoplay=1"
            });
        });

        function isBadIos() {
            var regex = /(iPhone|iPad|iPod);[^OS]*OS (\d)/;
            var matches = navigator.userAgent.match(regex);

            if (!matches) {
                return false;
            }

            return matches[2] < 8;
        }

        if (jQuery('article header').length && isBadIos()) {
            document.querySelector('article header').className = 'no-vh-support';
        }
    },
    finalize() {
        // JavaScript to be fired on all pages, after page specific JS is fired
    },
};
