// import external dependencies
import 'jquery';

// Import everything from autoload
import "./autoload/**/*"

// import local dependencies
import Router from './util/Router';
import common from './routes/common';

/** Populate Router instance with DOM routes */
var routes = new Router({
    // All pages
    common,
});

// Load Events
jQuery(document).ready(() => routes.loadEvents());

// import then needed Font Awesome functionality
import {library, dom} from '@fortawesome/fontawesome-svg-core';
// import the Facebook and Twitter icons
import {faFacebook, faTwitter, faInstagram, faYoutube} from "@fortawesome/free-brands-svg-icons";

import {faChevronRight, faChevronDown, faChevronLeft, faTimes} from "@fortawesome/pro-regular-svg-icons";

import {
    faPlay,
    faChevronRight as fasChevronRight,
    faChevronDown as fasChevronDown,
    faChevronLeft as fasChevronLeft,
} from "@fortawesome/pro-solid-svg-icons";

// add the imported icons to the library
library.add(faFacebook, faTwitter, faInstagram, faYoutube, faChevronRight, faChevronDown, faChevronLeft, faTimes, fasChevronRight, fasChevronDown, fasChevronLeft, faPlay);

// tell FontAwesome to watch the DOM and add the SVGs when it detects icon markup
jQuery(document).ready(() => dom.watch());
